import json
import asyncio
import websockets

true = True
false = False
null = None

clients = set()
mtserver = null

async def serve(websocket):
    global mtserver
    clients.add(websocket)
    try:
        async for message in websocket:
            try:
                print(f"Received: {message}")
                data = json.loads(message)
                if data["type"] == "chat":
                    for c in clients:
                        if c != websocket: await c.send(json.dumps({"type": "chat", "name": data["sender"], "msg": data["msg"]}))
                elif data["type"] == "online":
                    mtserver = websocket
                    for c in clients:
                        if c != mtserver: await c.send(json.dumps({"type": "online"}))
                else:
                    pass
                print(f"Sent: {message}")
            except:
                continue
    finally:
        if mtserver == websocket: mtserver = null
        clients.remove(websocket)

async def main():
    server = await websockets.serve(serve, "", 8001)
    await server.wait_closed()

asyncio.run(main())